/*
 * Decompiled with CFR 0.152.
 */
package snomrc;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import snomrc.HTTPFailedException;

public class ClientAuthentication {
    private static DefaultHttpClient httpclient;

    public static void doConnection(String host, int port, String page, String user, String password) throws IOException, HTTPFailedException {
        httpclient = new DefaultHttpClient();
        try {
            if (user != null && password != null) {
                httpclient.getCredentialsProvider().setCredentials(new AuthScope(host, port), new UsernamePasswordCredentials(user, password));
            }
            HttpGet httpget = new HttpGet("http://" + host + ":" + port + page);
            System.out.println("executing request " + httpget.getRequestLine());
            HttpResponse response = httpclient.execute(httpget);
            HttpEntity entity = response.getEntity();
            System.out.println("----------------------------------------");
            System.out.println(response.getStatusLine());
            if (entity != null) {
                System.out.println("Response content length: " + entity.getContentLength());
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new HTTPFailedException(response.getStatusLine().getReasonPhrase(), response.getStatusLine().getStatusCode());
            }
            EntityUtils.consume(entity);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    public static BufferedImage getDisplay(String host, int port, String page, String user, String password) throws IOException, HTTPFailedException {
        BufferedImage image;
        block8: {
            httpclient = new DefaultHttpClient();
            image = null;
            try {
                if (user != null && password != null) {
                    httpclient.getCredentialsProvider().setCredentials(new AuthScope(host, port), new UsernamePasswordCredentials(user, password));
                }
                HttpGet httpget = new HttpGet("http://" + host + ":" + port + page);
                System.out.println("executing request " + httpget.getRequestLine());
                HttpResponse response = httpclient.execute(httpget);
                HttpEntity entity = response.getEntity();
                System.out.println("----------------------------------------");
                System.out.println(response.getStatusLine());
                if (entity != null) {
                    System.out.println("Response content length: " + entity.getContentLength());
                }
                if (response.getStatusLine().getStatusCode() == 200) {
                    image = ImageIO.read(entity.getContent());
                    break block8;
                }
                throw new HTTPFailedException(response.getStatusLine().getReasonPhrase(), response.getStatusLine().getStatusCode());
            }
            catch (IOException e) {
                System.out.println(e);
                throw e;
            }
            finally {
                httpclient.getConnectionManager().shutdown();
            }
        }
        return image;
    }

    public static boolean doAbort() {
        httpclient.getConnectionManager().shutdown();
        return true;
    }
}

