/*
 * Decompiled with CFR 0.152.
 */
package snomrc.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import snomrc.AutoRefresh;
import snomrc.ClientAuthentication;
import snomrc.DoIt;
import snomrc.HTTPFailedException;
import snomrc.gui.ImagePanel;

public class MainGui
extends JFrame {
    private DoIt doing = null;
    private String lastValidSpeedDial = "";
    private String lastRightPKey = "";
    private AutoRefresh refresh;
    private Timer timer = new Timer();
    private ImagePanel pan;
    private JButton jButtonCancel;
    private JButton jButtonConference;
    private JButton jButtonDND;
    private JButton jButtonDial;
    private JButton jButtonDirectory;
    private JButton jButtonDown;
    private JButton jButtonEnter;
    private JButton jButtonF1;
    private JButton jButtonF2;
    private JButton jButtonF3;
    private JButton jButtonF4;
    private JButton jButtonHelp;
    private JButton jButtonHold;
    private JButton jButtonK0;
    private JButton jButtonK1;
    private JButton jButtonK2;
    private JButton jButtonK3;
    private JButton jButtonK4;
    private JButton jButtonK5;
    private JButton jButtonK6;
    private JButton jButtonK7;
    private JButton jButtonK8;
    private JButton jButtonK9;
    private JButton jButtonKPound;
    private JButton jButtonKStar;
    private JButton jButtonLeft;
    private JButton jButtonMenu;
    private JButton jButtonOffHook;
    private JButton jButtonOnHook;
    private JButton jButtonPKeys;
    private JButton jButtonRec;
    private JButton jButtonReconnect;
    private JButton jButtonRedial;
    private JButton jButtonRetrieve;
    private JButton jButtonRight;
    private JButton jButtonSnom;
    private JButton jButtonSpeaker;
    private JButton jButtonTransfer;
    private JButton jButtonUp;
    private JButton jButtonVolM;
    private JButton jButtonVolP;
    private JCheckBox jCheckFVersion;
    private JCheckBox jCheckRefresh;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelPKeys;
    private JLabel jLabelSpeedDial;
    private JLabel jLabelStatus;
    private JPanel jPanelArL;
    private JPanel jPanelArR;
    private JPanel jPanelArrows;
    private JPanel jPanelAtM;
    private JPanel jPanelDisplay;
    private JPanel jPanelFKeys;
    private JPanel jPanelFns;
    private JPanel jPanelHook;
    private JPanel jPanelNum;
    private JPanel jPanelPKey;
    private JPanel jPanelSettings;
    private JPanel jPanelSnd;
    private JPanel jPanelSpeedDial;
    private JPanel jPanelStatus;
    private JTextField jTextFieldHost;
    private JTextField jTextFieldPKeys;
    private JTextField jTextFieldPassword;
    private JTextField jTextFieldPort;
    private JTextField jTextFieldSpeedDial;
    private JTextField jTextFieldUser;

    public MainGui() {
        this.initComponents();
    }

    public void sendKey(String key, String what) {
        String pwd;
        this.jButtonReconnect.setText("STOP");
        String page = "/command.htm?key=" + key;
        if (key.equals("number")) {
            page = "/command.htm?number=" + what;
        }
        this.jLabelStatus.setText("...loading");
        this.jLabelStatus.setForeground(Color.red);
        this.jPanelStatus.updateUI();
        this.jPanelStatus.updateUI();
        if (key == null) {
            return;
        }
        String host = this.jTextFieldHost.getText();
        String strPort = this.jTextFieldPort.getText();
        if (strPort == null || strPort.length() < 1) {
            return;
        }
        int port = 80;
        try {
            port = Integer.parseInt(strPort);
        }
        catch (NumberFormatException e) {
            System.out.println(e);
            return;
        }
        String user = this.jTextFieldUser.getText();
        if (user != null && user.length() < 1) {
            user = null;
        }
        if ((pwd = this.jTextFieldPassword.getText()) != null && pwd.length() < 1) {
            pwd = null;
        }
        try {
            ClientAuthentication.doConnection(host, port, page, user, pwd);
        }
        catch (HTTPFailedException ex) {
            JOptionPane.showMessageDialog(this, ex.getStatusCode() + " " + ex.getMessage(), "No connection to host", 0);
            this.resetGui();
        }
        catch (IOException ex) {
            if (this.doing != null) {
                JOptionPane.showMessageDialog(this, "Connection error", "No connection to host", 0);
                this.resetGui();
            }
            return;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            System.out.println("error on waiting");
        }
        BufferedImage img = null;
        try {
            img = ClientAuthentication.getDisplay(host, port, "/screen.bmp", user, pwd);
        }
        catch (HTTPFailedException ex) {
            JOptionPane.showMessageDialog(this, ex.getStatusCode() + " " + ex.getMessage(), "No connection to host", 0);
            this.resetGui();
        }
        catch (IOException ex) {
            if (this.doing != null) {
                JOptionPane.showMessageDialog(this, "Connection error", "No connection to host", 0);
                this.resetGui();
            }
            return;
        }
        if (this.pan != null) {
            this.jPanelDisplay.remove(this.pan);
            this.pan = null;
        }
        if (img != null) {
            this.pan = new ImagePanel(img);
            this.jPanelDisplay.add(this.pan);
        }
        this.resetGui();
        this.jPanelDisplay.updateUI();
        this.jPanelDisplay.updateUI();
    }

    public boolean newFW() {
        return this.jCheckFVersion.isSelected();
    }

    public void updateImage() {
        String pwd;
        this.jLabelStatus.setText("...loading");
        this.jLabelStatus.setForeground(Color.red);
        this.jPanelStatus.updateUI();
        String host = this.jTextFieldHost.getText();
        String strPort = this.jTextFieldPort.getText();
        if (strPort == null || strPort.length() < 1) {
            return;
        }
        int port = 80;
        try {
            port = Integer.parseInt(strPort);
        }
        catch (NumberFormatException e) {
            System.out.println(e);
            return;
        }
        String user = this.jTextFieldUser.getText();
        if (user != null && user.length() < 1) {
            user = null;
        }
        if ((pwd = this.jTextFieldPassword.getText()) != null && pwd.length() < 1) {
            pwd = null;
        }
        BufferedImage img = null;
        try {
            img = ClientAuthentication.getDisplay(host, port, "/screen.bmp", user, pwd);
        }
        catch (HTTPFailedException ex) {
            JOptionPane.showMessageDialog(this, ex.getStatusCode() + " " + ex.getMessage(), "No connection to host", 0);
            this.resetGui();
        }
        catch (IOException ex) {
            if (this.doing != null) {
                JOptionPane.showMessageDialog(this, "Connection error", "No connection to host", 0);
                this.resetGui();
            }
            return;
        }
        if (this.pan != null) {
            this.jPanelDisplay.remove(this.pan);
            this.pan = null;
        }
        if (img != null) {
            this.pan = new ImagePanel(img);
            this.jPanelDisplay.add(this.pan);
        }
        this.resetGui();
        this.jPanelDisplay.updateUI();
        this.jPanelDisplay.updateUI();
    }

    public void setDoing(DoIt doing) {
        this.doing = doing;
    }

    public DoIt getDoing() {
        return this.doing;
    }

    public boolean doAbort() {
        ClientAuthentication.doAbort();
        return true;
    }

    public void resetGui() {
        this.jLabelStatus.setText("ready...");
        this.jLabelStatus.setForeground(Color.black);
        this.jButtonReconnect.setText("(re)connect");
    }

    private void initComponents() {
        this.jPanelDisplay = new JPanel();
        this.jPanelFKeys = new JPanel();
        this.jButtonF1 = new JButton();
        this.jButtonF2 = new JButton();
        this.jButtonF3 = new JButton();
        this.jButtonF4 = new JButton();
        this.jButtonRec = new JButton();
        this.jButtonRetrieve = new JButton();
        this.jPanelSnd = new JPanel();
        this.jButtonVolP = new JButton();
        this.jButtonVolM = new JButton();
        this.jButtonSpeaker = new JButton();
        this.jPanelArrows = new JPanel();
        this.jPanelArL = new JPanel();
        this.jButtonEnter = new JButton();
        this.jButtonLeft = new JButton();
        this.jPanelAtM = new JPanel();
        this.jButtonUp = new JButton();
        this.jButtonDown = new JButton();
        this.jPanelArR = new JPanel();
        this.jButtonRight = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanelSettings = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldHost = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldPort = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldUser = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldPassword = new JTextField();
        this.jButtonReconnect = new JButton();
        this.jPanelPKey = new JPanel();
        this.jTextFieldPKeys = new JTextField();
        this.jLabelPKeys = new JLabel();
        this.jButtonPKeys = new JButton();
        this.jPanelNum = new JPanel();
        this.jButtonK1 = new JButton();
        this.jButtonK2 = new JButton();
        this.jButtonK3 = new JButton();
        this.jButtonK4 = new JButton();
        this.jButtonK5 = new JButton();
        this.jButtonK6 = new JButton();
        this.jButtonK7 = new JButton();
        this.jButtonK8 = new JButton();
        this.jButtonK9 = new JButton();
        this.jButtonKStar = new JButton();
        this.jButtonK0 = new JButton();
        this.jButtonKPound = new JButton();
        this.jPanelFns = new JPanel();
        this.jButtonRedial = new JButton();
        this.jButtonMenu = new JButton();
        this.jButtonHold = new JButton();
        this.jButtonTransfer = new JButton();
        this.jButtonDND = new JButton();
        this.jButtonConference = new JButton();
        this.jButtonSnom = new JButton();
        this.jButtonDirectory = new JButton();
        this.jButtonHelp = new JButton();
        this.jPanelHook = new JPanel();
        this.jButtonOnHook = new JButton();
        this.jButtonOffHook = new JButton();
        this.jPanelStatus = new JPanel();
        this.jLabelStatus = new JLabel();
        this.jPanelSpeedDial = new JPanel();
        this.jLabelSpeedDial = new JLabel();
        this.jTextFieldSpeedDial = new JTextField();
        this.jButtonDial = new JButton();
        this.jCheckFVersion = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jCheckRefresh = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("SnomRC - Snom Remote Control");
        this.setAlwaysOnTop(true);
        this.setCursor(new Cursor(0));
        this.setMaximumSize(new Dimension(600, 540));
        this.setMinimumSize(new Dimension(600, 540));
        this.setPreferredSize(new Dimension(600, 570));
        this.setResizable(false);
        this.jPanelDisplay.setMaximumSize(new Dimension(480, 230));
        this.jPanelDisplay.setMinimumSize(new Dimension(480, 230));
        this.jPanelDisplay.setPreferredSize(new Dimension(480, 230));
        this.jPanelDisplay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainGui.this.jPanelDisplayMouseClicked(evt);
            }
        });
        this.jPanelDisplay.setLayout(new BoxLayout(this.jPanelDisplay, 2));
        this.jPanelFKeys.setMaximumSize(new Dimension(Short.MAX_VALUE, 23));
        this.jButtonF1.setText("F1");
        this.jButtonF1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonF1ActionPerformed(evt);
            }
        });
        this.jButtonF2.setText("F2");
        this.jButtonF2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonF2ActionPerformed(evt);
            }
        });
        this.jButtonF3.setText("F3");
        this.jButtonF3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonF3ActionPerformed(evt);
            }
        });
        this.jButtonF4.setText("F4");
        this.jButtonF4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonF4ActionPerformed(evt);
            }
        });
        this.jButtonRec.setText("Rec");
        this.jButtonRec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonRecActionPerformed(evt);
            }
        });
        this.jButtonRetrieve.setText("Retrieve");
        this.jButtonRetrieve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonRetrieveActionPerformed(evt);
            }
        });
        GroupLayout jPanelFKeysLayout = new GroupLayout(this.jPanelFKeys);
        this.jPanelFKeys.setLayout(jPanelFKeysLayout);
        jPanelFKeysLayout.setHorizontalGroup(jPanelFKeysLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFKeysLayout.createSequentialGroup().addComponent(this.jButtonF1, -2, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonF2, -2, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonF3, -2, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonF4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRec).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRetrieve, -1, 77, Short.MAX_VALUE)));
        jPanelFKeysLayout.setVerticalGroup(jPanelFKeysLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFKeysLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonF1).addComponent(this.jButtonF2).addComponent(this.jButtonF3).addComponent(this.jButtonF4).addComponent(this.jButtonRec).addComponent(this.jButtonRetrieve)));
        this.jPanelSnd.setMaximumSize(new Dimension(120, 65));
        this.jPanelSnd.setMinimumSize(new Dimension(120, 65));
        this.jPanelSnd.setName("");
        this.jPanelSnd.setPreferredSize(new Dimension(120, 65));
        this.jButtonVolP.setText("Vol+");
        this.jButtonVolP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonVolPActionPerformed(evt);
            }
        });
        this.jPanelSnd.add(this.jButtonVolP);
        this.jButtonVolM.setText("Vol-");
        this.jButtonVolM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonVolMActionPerformed(evt);
            }
        });
        this.jPanelSnd.add(this.jButtonVolM);
        this.jButtonSpeaker.setText("SPEAKER");
        this.jButtonSpeaker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonSpeakerActionPerformed(evt);
            }
        });
        this.jPanelSnd.add(this.jButtonSpeaker);
        this.jPanelArrows.setLayout(new BoxLayout(this.jPanelArrows, 2));
        this.jPanelArL.setLayout(new BoxLayout(this.jPanelArL, 2));
        this.jButtonEnter.setText("  OK  ");
        this.jButtonEnter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonEnterActionPerformed(evt);
            }
        });
        this.jPanelArL.add(this.jButtonEnter);
        this.jButtonLeft.setText("L");
        this.jButtonLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonLeftActionPerformed(evt);
            }
        });
        this.jPanelArL.add(this.jButtonLeft);
        this.jPanelArrows.add(this.jPanelArL);
        this.jPanelAtM.setLayout(new BoxLayout(this.jPanelAtM, 1));
        this.jButtonUp.setText("Up");
        this.jButtonUp.setMaximumSize(new Dimension(59, 23));
        this.jButtonUp.setMinimumSize(new Dimension(59, 23));
        this.jButtonUp.setPreferredSize(new Dimension(59, 23));
        this.jButtonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonUpActionPerformed(evt);
            }
        });
        this.jPanelAtM.add(this.jButtonUp);
        this.jButtonDown.setText("Down");
        this.jButtonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonDownActionPerformed(evt);
            }
        });
        this.jPanelAtM.add(this.jButtonDown);
        this.jPanelArrows.add(this.jPanelAtM);
        this.jPanelArR.setLayout(new BoxLayout(this.jPanelArR, 0));
        this.jButtonRight.setText("R");
        this.jButtonRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonRightActionPerformed(evt);
            }
        });
        this.jPanelArR.add(this.jButtonRight);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanelArR.add(this.jButtonCancel);
        this.jPanelArrows.add(this.jPanelArR);
        this.jPanelSettings.setMaximumSize(new Dimension(680, 100));
        this.jPanelSettings.setMinimumSize(new Dimension(0, 100));
        this.jPanelSettings.setPreferredSize(new Dimension(440, 100));
        this.jLabel1.setFont(new Font("Tahoma", 0, 12));
        this.jLabel1.setText("Host:Port");
        this.jLabel1.setMaximumSize(new Dimension(100, 15));
        this.jLabel1.setMinimumSize(new Dimension(100, 15));
        this.jLabel1.setName("");
        this.jLabel1.setPreferredSize(new Dimension(100, 15));
        this.jTextFieldHost.setFont(new Font("Tahoma", 0, 12));
        this.jTextFieldHost.setToolTipText("");
        this.jTextFieldHost.setMinimumSize(new Dimension(200, 26));
        this.jTextFieldHost.setPreferredSize(new Dimension(200, 26));
        this.jTextFieldHost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jTextFieldHostActionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("Tahoma", 0, 14));
        this.jLabel4.setText(":");
        this.jTextFieldPort.setFont(new Font("Tahoma", 0, 12));
        this.jTextFieldPort.setText("80");
        this.jTextFieldPort.setToolTipText("");
        this.jTextFieldPort.setMinimumSize(new Dimension(60, 26));
        this.jTextFieldPort.setPreferredSize(new Dimension(60, 26));
        this.jTextFieldPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jTextFieldPortActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 0, 12));
        this.jLabel2.setText("Username");
        this.jLabel2.setMaximumSize(new Dimension(100, 15));
        this.jLabel2.setMinimumSize(new Dimension(100, 15));
        this.jLabel2.setName("");
        this.jLabel2.setPreferredSize(new Dimension(100, 15));
        this.jTextFieldUser.setFont(new Font("Tahoma", 0, 12));
        this.jTextFieldUser.setToolTipText("");
        this.jTextFieldUser.setMinimumSize(new Dimension(300, 26));
        this.jTextFieldUser.setPreferredSize(new Dimension(300, 26));
        this.jLabel3.setFont(new Font("Tahoma", 0, 12));
        this.jLabel3.setText("Password");
        this.jLabel3.setMaximumSize(new Dimension(100, 15));
        this.jLabel3.setMinimumSize(new Dimension(100, 15));
        this.jLabel3.setName("");
        this.jLabel3.setPreferredSize(new Dimension(100, 15));
        this.jTextFieldPassword.setFont(new Font("Tahoma", 0, 12));
        this.jTextFieldPassword.setToolTipText("");
        this.jTextFieldPassword.setMinimumSize(new Dimension(300, 26));
        this.jTextFieldPassword.setPreferredSize(new Dimension(300, 26));
        this.jButtonReconnect.setText("(re)connect");
        this.jButtonReconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonReconnectActionPerformed(evt);
            }
        });
        GroupLayout jPanelSettingsLayout = new GroupLayout(this.jPanelSettings);
        this.jPanelSettings.setLayout(jPanelSettingsLayout);
        jPanelSettingsLayout.setHorizontalGroup(jPanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSettingsLayout.createSequentialGroup().addComponent(this.jLabel2, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSettingsLayout.createSequentialGroup().addComponent(this.jTextFieldHost, -2, 163, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPort, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonReconnect)).addComponent(this.jTextFieldUser, -2, 319, -2)).addContainerGap(31, Short.MAX_VALUE)).addGroup(jPanelSettingsLayout.createSequentialGroup().addGroup(jPanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSettingsLayout.createSequentialGroup().addComponent(this.jLabel3, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPassword, -2, 319, -2)).addComponent(this.jLabel1, -2, 70, -2)).addGap(0, 0, Short.MAX_VALUE)));
        jPanelSettingsLayout.setVerticalGroup(jPanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSettingsLayout.createSequentialGroup().addGroup(jPanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldHost, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jTextFieldPort, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonReconnect)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldUser, -2, -1, -2).addComponent(this.jLabel2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPassword, -2, -1, -2).addComponent(this.jLabel3, -2, -1, -2)).addContainerGap()));
        this.jTextFieldPKeys.setFont(new Font("Tahoma", 0, 12));
        this.jTextFieldPKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jTextFieldPKeysActionPerformed(evt);
            }
        });
        this.jTextFieldPKeys.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MainGui.this.jTextFieldPKeysKeyReleased(evt);
            }
        });
        this.jLabelPKeys.setFont(new Font("Tahoma", 0, 12));
        this.jLabelPKeys.setText("P-Key: ");
        this.jButtonPKeys.setText("execute");
        this.jButtonPKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonPKeysActionPerformed(evt);
            }
        });
        GroupLayout jPanelPKeyLayout = new GroupLayout(this.jPanelPKey);
        this.jPanelPKey.setLayout(jPanelPKeyLayout);
        jPanelPKeyLayout.setHorizontalGroup(jPanelPKeyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPKeyLayout.createSequentialGroup().addComponent(this.jLabelPKeys).addGap(22, 22, 22).addComponent(this.jTextFieldPKeys, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPKeys, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanelPKeyLayout.setVerticalGroup(jPanelPKeyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPKeyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPKeys, -2, -1, -2).addComponent(this.jButtonPKeys).addComponent(this.jLabelPKeys)));
        this.jPanelNum.setEnabled(false);
        this.jPanelNum.setMaximumSize(new Dimension(300, 300));
        this.jPanelNum.setLayout(new GridLayout(4, 3, 5, 5));
        this.jButtonK1.setText("1");
        this.jButtonK1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonK1ActionPerformed(evt);
            }
        });
        this.jPanelNum.add(this.jButtonK1);
        this.jButtonK2.setText("2");
        this.jButtonK2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonK2ActionPerformed(evt);
            }
        });
        this.jPanelNum.add(this.jButtonK2);
        this.jButtonK3.setText("3");
        this.jButtonK3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonK3ActionPerformed(evt);
            }
        });
        this.jPanelNum.add(this.jButtonK3);
        this.jButtonK4.setText("4");
        this.jButtonK4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonK4ActionPerformed(evt);
            }
        });
        this.jPanelNum.add(this.jButtonK4);
        this.jButtonK5.setText("5");
        this.jButtonK5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonK5ActionPerformed(evt);
            }
        });
        this.jPanelNum.add(this.jButtonK5);
        this.jButtonK6.setText("6");
        this.jButtonK6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonK6ActionPerformed(evt);
            }
        });
        this.jPanelNum.add(this.jButtonK6);
        this.jButtonK7.setText("7");
        this.jButtonK7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonK7ActionPerformed(evt);
            }
        });
        this.jPanelNum.add(this.jButtonK7);
        this.jButtonK8.setText("8");
        this.jButtonK8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonK8ActionPerformed(evt);
            }
        });
        this.jPanelNum.add(this.jButtonK8);
        this.jButtonK9.setText("9");
        this.jButtonK9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonK9ActionPerformed(evt);
            }
        });
        this.jPanelNum.add(this.jButtonK9);
        this.jButtonKStar.setText("*");
        this.jButtonKStar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonKStarActionPerformed(evt);
            }
        });
        this.jPanelNum.add(this.jButtonKStar);
        this.jButtonK0.setText("0");
        this.jButtonK0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonK0ActionPerformed(evt);
            }
        });
        this.jPanelNum.add(this.jButtonK0);
        this.jButtonKPound.setText("#");
        this.jButtonKPound.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonKPoundActionPerformed(evt);
            }
        });
        this.jPanelNum.add(this.jButtonKPound);
        this.jPanelFns.setMaximumSize(new Dimension(100, 300));
        this.jPanelFns.setLayout(new GridLayout(0, 1, 5, 5));
        this.jButtonRedial.setText("Redial");
        this.jButtonRedial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonRedialActionPerformed(evt);
            }
        });
        this.jPanelFns.add(this.jButtonRedial);
        this.jButtonMenu.setText("Menu");
        this.jButtonMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonMenuActionPerformed(evt);
            }
        });
        this.jPanelFns.add(this.jButtonMenu);
        this.jButtonHold.setText("Hold");
        this.jButtonHold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonHoldActionPerformed(evt);
            }
        });
        this.jPanelFns.add(this.jButtonHold);
        this.jButtonTransfer.setText("Transfer");
        this.jButtonTransfer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonTransferActionPerformed(evt);
            }
        });
        this.jPanelFns.add(this.jButtonTransfer);
        this.jButtonDND.setText("DND");
        this.jButtonDND.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonDNDActionPerformed(evt);
            }
        });
        this.jPanelFns.add(this.jButtonDND);
        this.jButtonConference.setText("Conference");
        this.jButtonConference.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonConferenceActionPerformed(evt);
            }
        });
        this.jPanelFns.add(this.jButtonConference);
        this.jButtonSnom.setActionCommand("Snom");
        this.jButtonSnom.setLabel("Snom");
        this.jButtonSnom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonSnomActionPerformed(evt);
            }
        });
        this.jPanelFns.add(this.jButtonSnom);
        this.jButtonDirectory.setText("Directory");
        this.jButtonDirectory.setEnabled(false);
        this.jButtonDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonDirectoryActionPerformed(evt);
            }
        });
        this.jPanelFns.add(this.jButtonDirectory);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanelFns.add(this.jButtonHelp);
        this.jPanelHook.setLayout(new GridLayout(0, 2, 1, 5));
        this.jButtonOnHook.setText("On Hook");
        this.jButtonOnHook.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonOnHookActionPerformed(evt);
            }
        });
        this.jPanelHook.add(this.jButtonOnHook);
        this.jButtonOffHook.setText("Off Hook");
        this.jButtonOffHook.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonOffHookActionPerformed(evt);
            }
        });
        this.jPanelHook.add(this.jButtonOffHook);
        this.jPanelFns.add(this.jPanelHook);
        this.jPanelStatus.setMaximumSize(new Dimension(200, 100));
        this.jPanelStatus.setPreferredSize(new Dimension(200, 30));
        this.jLabelStatus.setFont(new Font("Tahoma", 1, 18));
        this.jLabelStatus.setText("ready...");
        this.jPanelStatus.add(this.jLabelStatus);
        this.jLabelSpeedDial.setFont(new Font("Tahoma", 0, 12));
        this.jLabelSpeedDial.setText("Speedial:");
        this.jTextFieldSpeedDial.setFont(new Font("Tahoma", 0, 12));
        this.jTextFieldSpeedDial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jTextFieldSpeedDialActionPerformed(evt);
            }
        });
        this.jTextFieldSpeedDial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MainGui.this.jTextFieldSpeedDialKeyReleased(evt);
            }
        });
        this.jButtonDial.setText("dial");
        this.jButtonDial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jButtonDialActionPerformed(evt);
            }
        });
        GroupLayout jPanelSpeedDialLayout = new GroupLayout(this.jPanelSpeedDial);
        this.jPanelSpeedDial.setLayout(jPanelSpeedDialLayout);
        jPanelSpeedDialLayout.setHorizontalGroup(jPanelSpeedDialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSpeedDialLayout.createSequentialGroup().addComponent(this.jLabelSpeedDial, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextFieldSpeedDial, -2, 141, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDial).addGap(22, 22, 22)));
        jPanelSpeedDialLayout.setVerticalGroup(jPanelSpeedDialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSpeedDialLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelSpeedDial).addComponent(this.jTextFieldSpeedDial, -2, -1, -2).addComponent(this.jButtonDial)));
        this.jCheckFVersion.setText("Firmware > 8.4");
        this.jCheckFVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jCheckFVersionActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Copyright (c) LocaNet oHG");
        this.jCheckRefresh.setText("Auto-Refresh");
        this.jCheckRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGui.this.jCheckRefreshActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jPanelNum, -2, 125, -2).addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelSettings, -2, 414, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelPKey, -2, -1, -2).addComponent(this.jPanelSpeedDial, -2, 264, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelStatus, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckFVersion).addComponent(this.jCheckRefresh)).addGap(0, 0, Short.MAX_VALUE)))))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanelFKeys, -2, -1, -2).addGap(76, 76, 76)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelDisplay, -2, 414, -2).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addComponent(this.jPanelSnd, -2, 120, -2)).addGroup(layout.createSequentialGroup().addGap(156, 156, 156).addComponent(this.jPanelArrows, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addComponent(this.jPanelFns, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel5).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanelDisplay, -2, 201, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelFKeys, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelArrows, -2, 55, -2).addComponent(this.jPanelSnd, -2, -1, -2))).addComponent(this.jPanelFns, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelPKey, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jCheckFVersion).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckRefresh))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanelSpeedDial, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.jPanelSettings, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jPanelStatus, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)))).addComponent(this.jPanelNum, -2, 168, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5)));
        this.pack();
    }

    private void jButtonF1ActionPerformed(ActionEvent evt) {
        new DoIt(this, "F1", "").start();
    }

    private void jButtonUpActionPerformed(ActionEvent evt) {
        new DoIt(this, "UP", "").start();
    }

    private void jButtonSpeakerActionPerformed(ActionEvent evt) {
        new DoIt(this, "SPEAKER", "").start();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        new DoIt(this, "CANCEL", "").start();
    }

    private void jButtonK1ActionPerformed(ActionEvent evt) {
        new DoIt(this, "1", "").start();
    }

    private void jButtonHoldActionPerformed(ActionEvent evt) {
        if (this.newFW()) {
            new DoIt(this, "F_HOLD", "").start();
        } else {
            new DoIt(this, "F_R", "").start();
        }
    }

    private void jButtonTransferActionPerformed(ActionEvent evt) {
        new DoIt(this, "TRANSFER", "").start();
    }

    private void jButtonK2ActionPerformed(ActionEvent evt) {
        new DoIt(this, "2", "").start();
    }

    private void jButtonK3ActionPerformed(ActionEvent evt) {
        new DoIt(this, "3", "").start();
    }

    private void jTextFieldHostActionPerformed(ActionEvent evt) {
        if (this.jButtonReconnect.getText().equals("(re)connect")) {
            this.jButtonReconnect.setText("STOP");
            new DoIt(this, null, "").start();
        } else {
            this.jLabelStatus.setText("stopping!!");
            this.jButtonReconnect.setText("(re)connect");
            if (this.doing.doAbort()) {
                this.resetGui();
                this.doing = null;
            }
        }
    }

    private void jTextFieldPortActionPerformed(ActionEvent evt) {
    }

    private void jButtonK4ActionPerformed(ActionEvent evt) {
        new DoIt(this, "4", "").start();
    }

    private void jButtonK5ActionPerformed(ActionEvent evt) {
        new DoIt(this, "5", "").start();
    }

    private void jButtonK6ActionPerformed(ActionEvent evt) {
        new DoIt(this, "6", "").start();
    }

    private void jButtonK7ActionPerformed(ActionEvent evt) {
        new DoIt(this, "7", "").start();
    }

    private void jButtonK8ActionPerformed(ActionEvent evt) {
        new DoIt(this, "8", "").start();
    }

    private void jButtonK9ActionPerformed(ActionEvent evt) {
        new DoIt(this, "9", "").start();
    }

    private void jButtonK0ActionPerformed(ActionEvent evt) {
        new DoIt(this, "0", "").start();
    }

    private void jButtonKStarActionPerformed(ActionEvent evt) {
        new DoIt(this, "*", "").start();
    }

    private void jButtonKPoundActionPerformed(ActionEvent evt) {
        new DoIt(this, "%23", "").start();
    }

    private void jButtonF2ActionPerformed(ActionEvent evt) {
        new DoIt(this, "F2", "").start();
    }

    private void jButtonF3ActionPerformed(ActionEvent evt) {
        new DoIt(this, "F3", "").start();
    }

    private void jButtonF4ActionPerformed(ActionEvent evt) {
        new DoIt(this, "F4", "").start();
    }

    private void jButtonVolPActionPerformed(ActionEvent evt) {
        new DoIt(this, "VOLUME_UP", "").start();
    }

    private void jButtonVolMActionPerformed(ActionEvent evt) {
        new DoIt(this, "VOLUME_DOWN", "").start();
    }

    private void jButtonEnterActionPerformed(ActionEvent evt) {
        new DoIt(this, "ENTER", "").start();
    }

    private void jButtonLeftActionPerformed(ActionEvent evt) {
        new DoIt(this, "LEFT", "").start();
    }

    private void jButtonDownActionPerformed(ActionEvent evt) {
        new DoIt(this, "DOWN", "").start();
    }

    private void jButtonRightActionPerformed(ActionEvent evt) {
        new DoIt(this, "RIGHT", "").start();
    }

    private void jButtonRecActionPerformed(ActionEvent evt) {
        new DoIt(this, "REC", "").start();
    }

    private void jButtonRedialActionPerformed(ActionEvent evt) {
        new DoIt(this, "REDIAL", "").start();
    }

    private void jButtonMenuActionPerformed(ActionEvent evt) {
        new DoIt(this, "MENU", "").start();
    }

    private void jButtonDNDActionPerformed(ActionEvent evt) {
        new DoIt(this, "DND", "").start();
    }

    private void jButtonOnHookActionPerformed(ActionEvent evt) {
        new DoIt(this, "ONHOOK", "").start();
    }

    private void jButtonOffHookActionPerformed(ActionEvent evt) {
        new DoIt(this, "OFFHOOK", "").start();
    }

    private void jPanelDisplayMouseClicked(MouseEvent evt) {
        new DoIt(this, null, "").start();
    }

    private void jButtonConferenceActionPerformed(ActionEvent evt) {
        new DoIt(this, "CONFERENCE", "").start();
    }

    private void jButtonSnomActionPerformed(ActionEvent evt) {
        new DoIt(this, "SNOM", "").start();
    }

    private void jButtonDirectoryActionPerformed(ActionEvent evt) {
    }

    private void jButtonReconnectActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        if (button.getText().equals("(re)connect")) {
            button.setText("STOP");
            new DoIt(this, null, "").start();
        } else {
            this.jLabelStatus.setText("stopping!!!");
            button.setText("(re)connect");
            if (this.doing.doAbort()) {
                this.resetGui();
                this.doing = null;
            }
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        new DoIt(this, "HELP", "").start();
    }

    private void jButtonRetrieveActionPerformed(ActionEvent evt) {
        new DoIt(this, "Retrieve", "").start();
    }

    private void jTextFieldSpeedDialActionPerformed(ActionEvent evt) {
        JTextField textfield = (JTextField)evt.getSource();
        new DoIt(this, "number", textfield.getText()).start();
    }

    private void jButtonDialActionPerformed(ActionEvent evt) {
        new DoIt(this, "number", this.jTextFieldSpeedDial.getText()).start();
    }

    private void jTextFieldSpeedDialKeyReleased(KeyEvent evt) {
        String newInput = this.jTextFieldSpeedDial.getText();
        char[] toCheck = newInput.toCharArray();
        char[] validChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '*', '#'};
        boolean inputIsValid = true;
        for (int i = 0; i < toCheck.length; ++i) {
            boolean foundValid = false;
            for (int j = 0; !foundValid && j < validChars.length; ++j) {
                if (toCheck[i] != validChars[j]) continue;
                foundValid = true;
                break;
            }
            if (foundValid) continue;
            this.jTextFieldSpeedDial.setText(this.lastValidSpeedDial);
            inputIsValid = false;
            break;
        }
        if (inputIsValid) {
            this.lastValidSpeedDial = newInput;
        }
    }

    private void jTextFieldPKeysActionPerformed(ActionEvent evt) {
        new DoIt(this, "P" + this.jTextFieldPKeys.getText(), "").start();
    }

    private void jTextFieldPKeysKeyReleased(KeyEvent evt) {
        try {
            int pKey = Integer.parseInt(this.jTextFieldPKeys.getText());
            if (pKey > 0 && pKey <= 999) {
                this.lastRightPKey = this.jTextFieldPKeys.getText() + "";
            } else {
                this.jTextFieldPKeys.setText(this.lastRightPKey + "");
            }
        }
        catch (NumberFormatException ex) {
            if (!this.jTextFieldPKeys.getText().equals("")) {
                this.jTextFieldPKeys.setText(this.lastRightPKey + "");
            }
            this.lastRightPKey = "";
        }
    }

    private void jButtonPKeysActionPerformed(ActionEvent evt) {
        new DoIt(this, "P" + this.jTextFieldPKeys.getText(), "").start();
    }

    private void jCheckFVersionActionPerformed(ActionEvent evt) {
    }

    private void jCheckRefreshActionPerformed(ActionEvent evt) {
        if (this.jCheckRefresh.isSelected()) {
            this.refresh = new AutoRefresh(this);
            this.timer.schedule((TimerTask)this.refresh, 1000L, 3000L);
        } else {
            this.refresh.cancel();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainGui.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainGui.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainGui.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainGui.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainGui().setVisible(true);
            }
        });
    }
}

